﻿using VA.TMP.Integration.VIMT.Messages.VirtualMeetingRoom;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.Delete
{
    /// <summary>
    /// Create Response step.
    /// </summary>
    public class CreateResponseStep : FilterBase<VirtualMeetingRoomDeleteStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VirtualMeetingRoomDeleteStateObject state)
        {
            if (state.UseFakeResponse)
            {
                state.VirtualMeetingRoomDeleteResponseMessage = new VirtualMeetingRoomDeleteResponseMessage
                {
                    ExceptionMessage = "*****THIS IS FAKE DATA. VMR NOT CANCELED*****",
                    ExceptionOccured = false,
                    MiscData = string.Empty,
                    SerializedInstance = state.SerializedVirtualMeetingRoomDelete
                };
            }
            else
            {
                state.VirtualMeetingRoomDeleteResponseMessage = state.ExceptionOccured
                ? new VirtualMeetingRoomDeleteResponseMessage { ExceptionOccured = true, ExceptionMessage = state.ExceptionMessage }
                : new VirtualMeetingRoomDeleteResponseMessage
                {
                    ExceptionMessage = string.Empty,
                    ExceptionOccured = false,
                    MiscData = state.MiscDataForResponse,
                    SerializedInstance = state.SerializedVirtualMeetingRoomDelete
                };
            }
        }
    }
}